# Generated by Django 2.0.3 on 2018-04-24 16:43

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        ('carsharing', '0043_car_responsible_picker'),
    ]

    operations = [
        migrations.AddField(
            model_name='cardocument',
            name='car_insurance_policy',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarInsurance'),
        ),
        migrations.AlterField(
            model_name='cardocument',
            name='type',
            field=models.CharField(choices=[('car_hardware_beacon', 'CAR_HARDWARE_BEACON'), ('car_hardware_head', 'CAR_HARDWARE_HEAD'), ('car_hardware_modem', 'CAR_HARDWARE_MODEM'), ('car_hardware_sim', 'CAR_HARDWARE_SIM'), ('car_hardware_vega', 'CAR_HARDWARE_VEGA'), ('car_insurance_policy', 'CAR_INSURANCE_POLICY'), ('car_registry_document', 'CAR_REGISTRY_DOCUMENT')], max_length=32),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='cardocument',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (\n                    (type = 'car_hardware_beacon' AND car_hardware_beacon_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_head' AND car_hardware_head_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_modem' AND car_hardware_modem_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_sim' AND car_hardware_sim_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_vega' AND car_hardware_vega_id IS NOT NULL)\n                    OR\n                    (type = 'car_insurance_policy' AND car_insurance_policy_id IS NOT NULL)                    \n                    OR\n                    (type = 'car_registry_document' AND car_registry_document_id IS NOT NULL)\n                  )\n                  AND\n                  (\n                    CASE WHEN car_hardware_beacon_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_head_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_modem_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_sim_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_vega_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_insurance_policy_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_registry_document_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
