import uuid

from django.db import models

from cars.carsharing.models import Car
from cars.users.models import User
from .car_assembly_stage import CarAssemblyStage


class CarAssemblyPhoto(models.Model):

    id = models.UUIDField(primary_key=True, default=uuid.uuid4)

    stage = models.ForeignKey(
        CarAssemblyStage,
        related_name='photos',
        on_delete=models.CASCADE,
    )

    car = models.ForeignKey(
        Car,
        related_name='assembly_photos',
        on_delete=models.CASCADE,
    )

    added_by = models.ForeignKey(
        User,
        related_name='assembly_photos',
        on_delete=models.CASCADE,
    )
    added_at = models.DateTimeField()

    link = models.CharField(max_length=256)
    thumbnail_link = models.CharField(max_length=256, null=True)

    class Meta:
        db_table = 'car_assembly_photo'
