import uuid

from django.core.exceptions import ObjectDoesNotExist
from django.db import models

from phonenumber_field.modelfields import PhoneNumberField


class CarHardwareSim(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    phone_number = PhoneNumberField()
    icc = models.BigIntegerField(unique=True)

    class Meta:
        db_table = 'car_hardware_sim'

    def is_used(self):
        try:
            usage = self.vega_primary_sim
            return True
        except ObjectDoesNotExist:
            pass
        try:
            usage = self.vega_secondary_sim
            return True
        except ObjectDoesNotExist:
            pass
        try:
            usage = self.modem
            return True
        except ObjectDoesNotExist:
            pass
        try:
            usage = self.beacon
            return True
        except ObjectDoesNotExist:
            pass
        return False


class CarHardwareBeacon(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    imei = models.BigIntegerField(unique=True)
    serial_number = models.CharField(max_length=16, null=True)

    sim = models.OneToOneField(
        CarHardwareSim,
        null=True,
        related_name='beacon',
        on_delete=models.CASCADE,
    )

    class Meta:
        db_table = 'car_hardware_beacon'


class CarHardwareVega(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    imei = models.BigIntegerField(unique=True)

    primary_sim = models.OneToOneField(
        CarHardwareSim,
        null=True,
        related_name='vega_primary_sim',
        on_delete=models.CASCADE,
    )

    secondary_sim = models.OneToOneField(
        CarHardwareSim,
        null=True,
        related_name='vega_secondary_sim',
        on_delete=models.CASCADE,
    )

    class Meta:
        db_table = 'car_hardware_vega'


class CarHardwareModem(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    sim = models.OneToOneField(
        CarHardwareSim,
        related_name='modem',
        null=True,
        on_delete=models.CASCADE,
    )

    class Meta:
        db_table = 'car_hardware_modem'


class CarHardwareHead(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    head_id = models.CharField(max_length=64)
    device_id = models.CharField(max_length=64, null=True)

    class Meta:
        db_table = 'car_hardware_head'
