from django.db import models

from .car import Car


class CarInsurance(models.Model):

    agreement_number = models.CharField(max_length=64, null=True)
    agreement_partner_number = models.CharField(max_length=64, null=True)
    base_cost = models.DecimalField(decimal_places=2, max_digits=7)
    per_minute_cost = models.DecimalField(decimal_places=2, max_digits=7)

    car = models.OneToOneField(
        Car,
        related_name='insurance',
        on_delete=models.CASCADE,
        null=True,
    )

    class Meta:
        db_table = 'car_insurance'
