from django.db import models

from .car import Car


class CarLocation(models.Model):
    car = models.OneToOneField(
        Car,
        related_name='location',
        on_delete=models.CASCADE,
    )
    lat = models.FloatField()
    lon = models.FloatField()
    course = models.IntegerField(null=True)
    updated_at = models.DateTimeField()

    class Meta:
        db_table = 'car_location'

    def __str__(self):
        return '{},{}'.format(self.lat, self.lon)
