import enum

from django.db import models

from .car_assembly_stage import CarAssemblyStage
from .car_model_specification import CarModelSpecification


class CarModel(models.Model):

    class FuelTypes(enum.Enum):
        PETROL_92 = '92'
        PETROL_95 = '95'
        PETROL_98 = '98'

    class FuelCapSides(enum.Enum):
        FUEL_CAP_SIDE_LEFT = 'left'
        FUEL_CAP_SIDE_RIGHT = 'right'

    code = models.CharField(max_length=16, primary_key=True)
    name = models.CharField(max_length=64)
    manufacturer = models.CharField(max_length=64)

    registry_manufacturer = models.CharField(max_length=64, null=True)
    registry_model = models.CharField(max_length=64, null=True)

    video_url = models.CharField(max_length=255, null=True)
    image_large_url = models.CharField(max_length=255, null=True)
    image_small_url = models.CharField(max_length=255, null=True)
    image_map_url = models.CharField(max_length=255, null=True)
    image_map_url_2x = models.CharField(max_length=255, null=True)
    image_map_url_3x = models.CharField(max_length=255, null=True)
    image_pin_url_2x = models.CharField(max_length=255, null=True)
    image_pin_url_3x = models.CharField(max_length=255, null=True)

    fuel_type = models.CharField(
        max_length=2,
        choices=[(x.value, x.name) for x in FuelTypes],
        null=True,
    )
    fuel_cap_side = models.CharField(
        max_length=5,
        choices=[(x.value, x.name) for x in FuelCapSides],
        null=True,
    )
    fuel_tank_volume = models.IntegerField(null=True)
    default_tags = models.CharField(max_length=8192, null=True)

    assembly_stages = models.ManyToManyField(CarAssemblyStage)
    specifications = models.ManyToManyField(CarModelSpecification)
    model_specifications = models.CharField(max_length=8196, default='[]')

    class Meta:
        db_table = 'car_model'

    def __str__(self):
        return self.name
