import uuid

from django.db import models


class CarRegistryDocument(models.Model):

    id = models.UUIDField(primary_key=True, default=uuid.uuid4)

    # entries, which are subject for update in Car model
    contract_id = models.CharField(max_length=32, null=True)
    registration_id = models.BigIntegerField(null=True)  # sts
    registration_date = models.DateTimeField(null=True)
    fuel_card_number = models.CharField(max_length=18, null=True)
    number = models.CharField(max_length=16, null=True)  # grz
    imei = models.BigIntegerField(null=True)  # vega

    # new entries from the Major registry
    contract_date = models.DateTimeField(null=True)
    transfer_date = models.DateTimeField(null=True)

    casco_number = models.CharField(max_length=16, null=True)
    osago_number = models.CharField(max_length=16, null=True)
    osago_date = models.DateTimeField(null=True)

    mark_by_pts = models.CharField(max_length=64, null=True)
    production_year = models.IntegerField(null=True)
    pts_number = models.CharField(max_length=16, null=True)
    antitheft_system = models.CharField(max_length=64, null=True)
    number_of_keys = models.IntegerField(null=True)
    parking_permit_start_date = models.DateTimeField(null=True)
    deptrans_documents_date = models.DateTimeField(null=True)

    transfer_receipt_mds_key = models.CharField(max_length=256, null=True, default=None)
    registration_mds_key = models.CharField(max_length=256, null=True, default=None)
    osago_mds_key = models.CharField(max_length=256, null=True, default=None)  # file

    class Meta:
        db_table = 'car_registry_document'
