import uuid

from django.db import models

from .car_model import CarModel


class CarModelSpecificationNew(models.Model):

    id = models.UUIDField(primary_key=True, default=uuid.uuid4)

    name = models.CharField(max_length=128)
    value = models.CharField(max_length=128)
    position = models.IntegerField()
    model = models.ForeignKey(
        CarModel,
        related_name='specifications_new',
        on_delete=models.CASCADE,
    )

    class Meta:
        db_table = 'car_model_specification'
