import enum
import uuid

from django.db import models

from cars.users.models import User
from .car import Car


class CarsharingTagPhoto(models.Model):
    """
    Photo associated with a certain tag.
    """

    class PhotoType(enum.Enum):
        AFTER = 'after'
        BEFORE = 'before'

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    tag_id = models.UUIDField(default=uuid.uuid4)
    car = models.ForeignKey(
        Car,
        on_delete=models.CASCADE,
        related_name='tag_photos',
        null=True,
    )

    link = models.CharField(max_length=256)
    thumbnail_link = models.CharField(max_length=256)

    type = models.CharField(
        max_length=16,
        choices=[(x.value, x.name) for x in PhotoType],
    )

    submitted_at = models.DateTimeField()
    submitted_by = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='uploaded_tag_photos'
    )

    class Meta:
        db_table = 'carsharing_tag_photo'
