from django.db import models

import cars.settings

from .car import Car


class CarTagsHistory(models.Model):
    '''read-only table'''
    history_event_id = models.BigAutoField(primary_key=True)
    history_user_id = models.TextField()
    object = models.ForeignKey(Car, models.DO_NOTHING)
    history_timestamp = models.IntegerField()
    history_action = models.TextField()
    tag = models.TextField(blank=True, null=True)
    data = models.TextField(blank=True, null=True)
    tag_id = models.UUIDField(blank=True, null=True)
    snapshot = models.TextField(blank=True, null=True)
    priority = models.IntegerField(blank=True, null=True)
    history_comment = models.TextField(blank=True, null=True)
    performer = models.TextField(blank=True, null=True)

    class Meta:
        managed = cars.settings.IS_TESTS
        db_table = 'car_tags_history'

    def save(self, *args, **kwargs):
        if cars.settings.IS_TESTS:
            return super().save(*args, **kwargs)
        raise NotImplementedError

    def delete(self, *args, **kwargs):
        if cars.settings.IS_TESTS:
            return super().delete(*args, **kwargs)
        raise NotImplementedError
