from django.db import models

from .car import Car


class CarTelematicsState(models.Model):
    car = models.OneToOneField(
        Car,
        related_name='telematics_state',
        on_delete=models.CASCADE,
    )

    mcu_firmware = models.CharField(max_length=64, null=True)
    mcu_firmware_updated_at = models.DateTimeField(null=True)

    mileage = models.FloatField(null=True)
    mileage_updated_at = models.DateTimeField(null=True)

    engine_temperature = models.FloatField(null=True)
    engine_temperature_updated_at = models.DateTimeField(null=True)

    fuel_level = models.FloatField(null=True)
    fuel_level_updated_at = models.DateTimeField(null=True)

    acc_charge = models.FloatField(null=True)
    acc_charge_updated_at = models.DateTimeField(null=True)

    acc_voltage = models.FloatField(null=True)
    acc_voltage_updated_at = models.DateTimeField(null=True)

    ext_voltage = models.FloatField(null=True)
    ext_voltage_updated_at = models.DateTimeField(null=True)

    front_left_door_open = models.NullBooleanField()
    front_left_door_open_updated_at = models.DateTimeField(null=True)

    front_right_door_open = models.NullBooleanField()
    front_right_door_open_updated_at = models.DateTimeField(null=True)

    rear_left_door_open = models.NullBooleanField()
    rear_left_door_open_updated_at = models.DateTimeField(null=True)

    rear_right_door_open = models.NullBooleanField()
    rear_right_door_open_updated_at = models.DateTimeField(null=True)

    transmission_selector_park = models.NullBooleanField()
    transmission_selector_park_updated_at = models.DateTimeField(null=True)

    ignition_on = models.NullBooleanField()
    ignition_on_updated_at = models.DateTimeField(null=True)

    engine_on = models.NullBooleanField()
    engine_on_updated_at = models.DateTimeField(null=True)

    hood_open = models.NullBooleanField()
    hood_open_updated_at = models.DateTimeField(null=True)

    trunk_open = models.NullBooleanField()
    trunk_open_updated_at = models.DateTimeField(null=True)

    dipped_beam_on = models.NullBooleanField()
    dipped_beam_on_updated_at = models.DateTimeField(null=True)

    main_beam_on = models.NullBooleanField()
    main_beam_on_updated_at = models.DateTimeField(null=True)

    hand_brake_on = models.NullBooleanField()
    hand_brake_on_updated_at = models.DateTimeField(null=True)

    pedal_brake_on = models.NullBooleanField()
    pedal_brake_on_updated_at = models.DateTimeField(null=True)


    # CAN: panel

    airbag_check_on = models.NullBooleanField()
    airbag_check_on_updated_at = models.DateTimeField(null=True)

    battery_check_on = models.NullBooleanField()
    battery_check_on_updated_at = models.DateTimeField(null=True)

    brake_check_on = models.NullBooleanField()
    brake_check_on_updated_at = models.DateTimeField(null=True)

    driver_belt_fastened = models.NullBooleanField()
    driver_belt_fastened_updated_at = models.DateTimeField(null=True)

    fuel_level_check_on = models.NullBooleanField()
    fuel_level_check_on_updated_at = models.DateTimeField(null=True)

    hand_brake_check_on = models.NullBooleanField()
    hand_brake_check_on_updated_at = models.DateTimeField(null=True)

    inflation_pressure_check_on = models.NullBooleanField()
    inflation_pressure_check_on_updated_at = models.DateTimeField(null=True)

    oil_check_on = models.NullBooleanField()
    oil_check_on_updated_at = models.DateTimeField(null=True)

    service_maintenance_check_on = models.NullBooleanField()
    service_maintenance_check_on_updated_at = models.DateTimeField(null=True)

    class Meta:
        db_table = 'car_telematics_state'
