from django.db import models

from .car import Car


class CarsharingParking(models.Model):
    car = models.ForeignKey(
        Car,
        on_delete=models.CASCADE,
        related_name='parkings',
    )
    debt_termination_max_duration_seconds = models.IntegerField(null=True)

    class Meta:
        db_table = 'carsharing_parking'

    def __str__(self):
        return '<CarsharingParking: car.id={}>'.format(self.car_id)
