from django.core.exceptions import ObjectDoesNotExist
from django.db import models

from .car import Car


class CarsharingReservation(models.Model):
    car = models.ForeignKey(
        Car,
        on_delete=models.CASCADE,
        related_name='reservations',
    )
    max_duration_seconds = models.IntegerField()
    car_location_course = models.IntegerField(null=True)
    car_location_lat = models.FloatField(null=True)
    car_location_lon = models.FloatField(null=True)

    class Meta:
        db_table = 'carsharing_reservation'

    def __str__(self):
        return '<CarsharingReservation: car.id={}>'.format(self.car_id)

    def get_termination_notification(self):
        try:
            termination_notification = self.termination_notification
        except ObjectDoesNotExist:
            termination_notification = None
        return termination_notification


class CarsharingReservationTerminationNotification(models.Model):
    reservation = models.OneToOneField(
        CarsharingReservation,
        on_delete=models.CASCADE,
        related_name='termination_notification',
    )
    notified_at = models.DateTimeField()

    class Meta:
        db_table = 'carsharing_reservation_termination_notification'

    def __str__(self):
        return (
            '<CarsharingReservationTerminationNotification: notified_at={}>'
            .format(self.notified_at)
        )
