from django.db import models

from .car import Car


class CarsharingReservationPaid(models.Model):
    car = models.ForeignKey(
        Car,
        on_delete=models.CASCADE,
        related_name='reservations_paid',
    )
    car_location_course = models.IntegerField(null=True)
    car_location_lat = models.FloatField(null=True)
    car_location_lon = models.FloatField(null=True)

    class Meta:
        db_table = 'carsharing_reservation_paid'

    def __str__(self):
        return '<CarsharingReservationPaid: car.id={}>'.format(self.car_id)
