from django.db import models

from .car import Car


class CarsharingRide(models.Model):
    car = models.ForeignKey(
        Car,
        on_delete=models.CASCADE,
        related_name='rides',
    )
    fix_id = models.CharField(max_length=64, unique=True, null=True)
    start_total_mileage = models.FloatField(null=True)
    finish_total_mileage = models.FloatField(null=True)

    class Meta:
        db_table = 'carsharing_ride'

    def __str__(self):
        return '<CarsharingRide: car.id={}>'.format(self.car_id)

    @property
    def mileage(self):
        if self.finish_total_mileage is not None:
            current_mileage = self.finish_total_mileage
        else:
            current_mileage = self.car.get_mileage()
        if (current_mileage is None
            or self.start_total_mileage is None):
            return 0
        return current_mileage - self.start_total_mileage
