from django.db import models

from .ride import CarsharingRide


class CarsharingRideInsuranceReport(models.Model):

    carsharing_ride = models.OneToOneField(
        CarsharingRide,
        related_name='insurance_report',
        on_delete=models.CASCADE,
    )

    start_time = models.DateTimeField()
    finish_time = models.DateTimeField()
    cost = models.DecimalField(decimal_places=2, max_digits=7)

    reported_at = models.DateTimeField()

    class Meta:
        db_table = 'carsharing_ride_insurance_report'
