from django.db import models
from django.contrib.postgres.fields import JSONField


class DriveRole(models.Model):
    role_id = models.TextField(primary_key=True)

    role_description = models.TextField(null=True)
    role_data = models.TextField(null=True)

    role_optional = models.NullBooleanField(default=False)
    role_is_public = models.NullBooleanField(default=False)
    role_group = models.IntegerField(null=True, default=0)
    role_is_idm = models.NullBooleanField(default=False)

    class Meta:
        db_table = 'drive_roles'
        managed = False


class DriveTagAction(models.Model):
    action_id = models.TextField(primary_key=True)
    action_description = models.TextField(null=True)
    action_meta = JSONField(null=True)
    action_type = models.TextField(default='')

    enabled = models.NullBooleanField(default=True)
    admin_interface_actions = models.TextField(null=True, default='')
    landing = models.TextField(null=True)

    id = models.IntegerField(null=True)  # auto field, drive_tag_actions_id_seq
    action_revision = models.BigIntegerField(unique=True)  # big auto field, drive_tag_actions_action_revision_seq

    class Meta:
        db_table = 'drive_tag_actions'
        managed = False


class DriveRoleAction(models.Model):
    action = models.ForeignKey(  # drive_role_actions_action_id_fkey
        DriveTagAction,
        on_delete=models.CASCADE,
        related_name='drive_role_actions_action',
    )
    role = models.ForeignKey(  # drive_role_actions_role_id_fkey
        DriveRole,
        on_delete=models.CASCADE,
        related_name='drive_role_actions_role',
    )
    role_action_meta = JSONField(null=True)

    class Meta:
        db_table = 'drive_role_actions'
        managed = False


class DriveRoleHierarchy(models.Model):
    slave_role = models.ForeignKey(  # drive_role_roles_role_id_fkey
        DriveRole,
        on_delete=models.CASCADE,
        related_name='drive_role_roles_role',
    )
    role = models.ForeignKey(  # drive_role_roles_slave_role_id_fkey
        DriveRole,
        on_delete=models.CASCADE,
        related_name='drive_role_roles_slave_role',
    )
    link_meta = JSONField(null=True)

    class Meta:
        db_table = 'drive_role_roles'
        managed = False
