from django.db import models


class DriveSettings(models.Model):
    setting_key = models.TextField(primary_key=True)
    setting_subkey = models.TextField(default='')
    setting_value = models.TextField()

    class Meta:
        db_table = 'drive_settings'
        managed = False

        indexes = [
            models.Index(
                fields=['setting_key', 'setting_subkey'],
                name='drive_settings_pkey',
            ),
        ]


class DriveSettingsHistory(models.Model):
    history_event_id = models.AutoField(primary_key=True)
    history_user_id = models.UUIDField()
    history_action = models.TextField()
    history_timestamp = models.IntegerField()
    history_comment = models.TextField(null=True)
    history_originator_id = models.TextField(null=True)

    setting_key = models.TextField(primary_key=True)
    setting_subkey = models.TextField(default='')
    setting_value = models.TextField()

    class Meta:
        db_table = 'drive_settings_history'
        managed = False
