from django.db import models
from django.contrib.postgres.fields import JSONField

from cars.carsharing.models import Car


class TagDescription(models.Model):
    name = models.CharField(max_length=32, null=False, primary_key=True)

    type = models.CharField(max_length=32, null=True)

    comment = models.TextField(null=True)

    author = models.CharField(max_length=50, null=True)

    meta = JSONField(null=True)

    ts = models.IntegerField(null=True)

    display_name = models.TextField(null=True, unique=True)

    default_priority = models.IntegerField(null=True, default=0)

    description_index = models.AutoField(null=False, primary_key=True)

    class Meta:
        managed = False
        db_table = 'tags_description'


class CarTag(models.Model):
    tag_id = models.UUIDField(primary_key=True)

    object_id = models.UUIDField()

    tag = models.CharField(max_length=50)

    data = models.TextField()

    performer = models.CharField(max_length=50, null=True)

    priority = models.IntegerField(null=True)

    snapshot = models.TextField(null=True)

    class Meta:
        managed = False
        db_table = 'car_tags'
