import enum

from django.db import models


class CarsharingTariff(models.Model):

    class Type(enum.Enum):
        PARKING = 'parking'
        RIDE = 'ride'

    type = models.CharField(
        max_length=16,
        choices=[(x.value, x.name) for x in Type],
    )
    cost_per_minute = models.DecimalField(max_digits=10, decimal_places=2)
    dow = models.PositiveSmallIntegerField(null=True)
    active_from = models.TimeField(null=True)
    active_to = models.TimeField(null=True)

    class Meta:
        db_table = 'carsharing_tariff'
        indexes = [
            models.Index(
                fields=['type'],
                name='carsharing_tariff_type_idx',
            ),
            models.Index(
                fields=['active_from'],
                name='carsharing_tariff_active_from_idx',
            ),
            models.Index(
                fields=['active_to'],
                name='carsharing_tariff_active_to_idx',
            ),
        ]

    def __repr__(self):
        return '{} tariff: {} to {} at {}'.format(
            self.type,
            self.active_from,
            self.active_to,
            self.cost_per_minute,
        )

    def __str__(self):
        return repr(self)

    def get_type(self):
        return self.Type(self.type)
