import uuid

import pytz
from django.db import models

from cars.users.models.user import User
from .car_model import CarModel


class CarsharingTariffPlan(models.Model):
    id = models.UUIDField(default=uuid.uuid4, primary_key=True)
    name = models.CharField(max_length=128, unique=True)
    created_at = models.DateTimeField()
    created_by = models.ForeignKey(User, on_delete=models.CASCADE)
    user_tag = models.CharField(max_length=128, null=True)
    car_model = models.ForeignKey(
        CarModel,
        on_delete=models.CASCADE,
        null=True,
    )

    class Meta:
        db_table = 'carsharing_tariff_plan'

    def __repr__(self):
        return (
            '<CarsharingTariffPlan: name={}, user_tag={}, car_model={}>'
            .format(
                self.name,
                self.user_tag,
                self.car_model_id,
            )
        )

    def __str__(self):
        return repr(self)

    def get_timezone(self):
        return pytz.timezone('Europe/Moscow')
