import datetime
import uuid

from django.db import models

from .tariff_plan import CarsharingTariffPlan


class CarsharingTariffPlanEntry(models.Model):
    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    tariff_plan = models.ForeignKey(
        CarsharingTariffPlan,
        on_delete=models.CASCADE,
        related_name='entries',
    )

    day_of_week = models.PositiveSmallIntegerField(null=True)
    start_time = models.TimeField(null=True)
    end_time = models.TimeField(null=True)

    parking_cost_per_minute = models.DecimalField(max_digits=10, decimal_places=2)
    ride_cost_per_minute = models.DecimalField(max_digits=10, decimal_places=2)

    class Meta:
        db_table = 'carsharing_tariff_plan_entry'

    def __repr__(self):
        return (
            '<CarsharingTariffPlanEntry: day_of_week={}'
            ', start_time={}, end_time={}, parking_cost_per_minute={}, ride_cost_per_minute={}>'
            .format(
                self.day_of_week,
                self.start_time,
                self.end_time,
                self.parking_cost_per_minute,
                self.ride_cost_per_minute,
            )
        )

    def __str__(self):
        return repr(self)

    def get_effective_start_time(self):
        start_time = self.start_time
        if start_time is None:
            start_time = datetime.time(0, 0)
        return start_time

    def get_effective_end_time(self):
        end_time = self.end_time
        if end_time is None:
            end_time = datetime.time(hour=23, minute=59, second=59, microsecond=999999)
        return end_time
