from django_yauth.authentication_mechanisms.base import BaseMechanism
from django_yauth.user import AnonymousYandexUser


class Mechanism(BaseMechanism):
    def extract_params(self, request):
        return {'request': request}

    def apply(self, request):
        return self.anonymous()

    def anonymous(self, session=None):
        """
        Этот метод для совместимости с yauth.
        Если вы используете только django AUTHENTICATION_BACKENDS
        вам достаточно возвращать None вместо AnonymousUser.
        Бекэнды yauth про это знают и будут отрабатывать как нужно.
        """
        return AnonymousYandexUser(blackbox_result=session, mechanism=self)
