class CarFilter(object):

    def __init__(self, city_id=None, is_free=True, operators=None, models=None, min_fuel=None):
        self.city_id = city_id
        self.is_free = is_free

        self.operators = operators
        if self.operators:
            self.operators = set(self.operators)

        self.models = models
        if self.models:
            self.models = set(self.models)

        # HACK: Aggregator client passes fuel level as [0,1] float while it should be [1,100].
        if min_fuel is not None and min_fuel <= 1.0:
            min_fuel *= 100

        self.min_fuel = min_fuel

    def __eq__(self, other):
        return (
            self.city_id == other.city_id
            and self.is_free == other.is_free
            and self.operators == other.operators
            and self.models == other.models
            and self.min_fuel == other.min_fuel
        )

    def to_dict(self):
        return {
            'city_id': self.city_id,
            'is_free': self.is_free,
            'operators': list(self.operators) if self.operators is not None else None,
            'models': list(self.models) if self.models is not None else None,
            'min_fuel': self.min_fuel,
        }

    @classmethod
    def from_dict(cls, data):
        return cls(
            city_id=data.get('city_id'),
            is_free=data.get('is_free'),
            operators=data.get('operators'),
            models=data.get('models'),
            min_fuel=data.get('min_fuel'),
        )

    def check(self, car):
        if self.city_id is not None and car.city_id != self.city_id:
            return False
        if self.is_free is not None and car.is_free != self.is_free:
            return False
        if self.operators is not None and car.operator not in self.operators:
            return False
        if self.models is not None and car.model not in self.models:
            return False
        if self.min_fuel is not None and car.fuel < self.min_fuel:
            return False
        return True
