import kubiki.geocoder

from cars.settings import GEOCODER as settings


class Geocoder:

    def __init__(self, url):
        self._client = kubiki.geocoder.Geocoder(url)

    @classmethod
    def from_settings(cls):
        return cls(
            url=settings['url'],
        )

    def geocode_coords(self, latitude, longitude):
        return self._client.geocode_coords(latitude, longitude)

    def most_relevant_name(self, latitude, longitude):
        resp = self.geocode_coords(latitude, longitude)
        if not resp.objects:
            return None
        return resp.objects[0].raw['name']
