import io

from PIL import Image


class ImageProcessor:

    def __init__(self, watermarker=None, resizer=None):
        self._watermarker = watermarker
        self._resizer = resizer

    def process(self, content, is_loaded=False, format='JPEG'):
        if not is_loaded:
            image = self._load_pil_image(content)
        else:
            image = content

        if self._resizer is not None:
            image = self._resizer.fit_to_size(image)

        if self._watermarker:
            image = self._watermarker.apply_watermark(
                image
            )

        return self._save_pil_image(image, format)

    def _load_pil_image(self, content):
        raw_content = io.BytesIO(
            content
        )
        return Image.open(raw_content)

    def _save_pil_image(self, image, format):
        output = io.BytesIO()
        if image.mode in ("RGBA", "P"):
            image = image.convert('RGB')
        image.save(output, format=format)
        return output.getvalue()
