from PIL import Image


class Resizer:

    def __init__(self, greater_side_to_fit=None):
        self._greater_side_to_fit = greater_side_to_fit

    def _resize(self, image, new_width, new_height):
        return image.resize(
            (int(new_width), int(new_height)),
            Image.ANTIALIAS,
        )

    def fit_to_size(self, image):
        width, height = image.size
        image_size_ratio = 1.0 * height / width

        if image_size_ratio <= 1.0:
            return self._resize(
                image=image,
                new_width=self._greater_side_to_fit,
                new_height=self._greater_side_to_fit * image_size_ratio
            )

        return self._resize(
            image=image,
            new_width=self._greater_side_to_fit / image_size_ratio,
            new_height=self._greater_side_to_fit
        )
