import logging
import random
import os

from ffmpy import FFmpeg
from PIL import Image

from .processor import ImageProcessor
from .watermarker import Watermarker


LOGGER = logging.getLogger(__name__)


class VideoWatermarker:

    def __init__(self, max_video_width, max_video_height, base_watermark_size, base_watermark_visibility, font_size):
        self._base_background = Image.new('RGBA', (max_video_width, max_video_height))
        self._base_watermark_size = base_watermark_size
        self._base_watermark_visibility = base_watermark_visibility
        self._watermark_font_size = font_size

    def watermark_video(self, video_raw_data, watermark_first_line, watermark_second_line=''):
        watermark_image_fname = self._get_random_string() + '.png'
        input_fname = self._get_random_string() + '.mp4'
        output_fname = self._get_random_string() + '.mp4'

        result_raw_data = None

        try:
            with open(input_fname, 'wb') as f:
                f.write(video_raw_data)

            image_processor = ImageProcessor(
                watermarker=Watermarker(
                    base_watermark_size=self._base_watermark_size,
                    watermark_visibility=self._base_watermark_visibility,
                    font_size=self._watermark_font_size,
                    watermark_first_line=watermark_first_line,
                    watermark_second_line=watermark_second_line,
                    random_padding=False,
                )
            )

            raw_bg_image = image_processor.process(self._base_background, True, 'PNG')
            with open(watermark_image_fname, 'wb') as f:
                f.write(raw_bg_image)

            ff = FFmpeg(
                inputs={
                    watermark_image_fname: '-i ' + input_fname,
                },
                outputs={
                    output_fname: '-filter_complex "overlay=10:10"',
                }
            )
            ff.run()

            with open(output_fname, 'rb') as f:
                result_raw_data = f.read()
        except Exception:
            LOGGER.exception('exception')
        finally:
            if os.path.exists(input_fname):
                os.remove(input_fname)
            if os.path.exists(output_fname):
                os.remove(output_fname)
            if os.path.exists(watermark_image_fname):
                os.remove(watermark_image_fname)

        return result_raw_data

    def _get_random_string(self):
        return '__tmp_' + str(random.randint(0, 10**10))
