import datetime
import logging

import botocore.response

import kubiki


LOGGER = logging.getLogger(__name__)


class MDSPushClientLogger(kubiki.push_client.PushClientLogger):

    def log(self, operation, bucket, key, response):  # pylint: disable=arguments-differ
        if response is None:
            response_to_log = None
        else:
            response_to_log = {}
            for k in list(response):
                v = response[k]
                if isinstance(v, botocore.response.StreamingBody):
                    continue
                if isinstance(v, datetime.datetime):
                    v = v.isoformat()
                response_to_log[k] = v

        data = {
            'operation': operation,
            'bucket': bucket,
            'key': key,
            'response': response_to_log,
        }

        try:
            super().log(type='mds', data=data)
        except Exception:
            LOGGER.exception('failed to log MDS operation')
