import enum


class CarModel(object):

    class Color(enum.Enum):
        BLACK = 'Чёрный'
        BLACK_WHITE = 'Чёрно-белый'
        BLUE = 'Синий'
        GRAY = 'Серый'
        GREEN = 'Зелёный'
        ORANGE = 'Оранжевый'
        RED = 'Красный'
        UNDEFINED = None
        WHITE = 'Белый'
        YELLOW = 'Жёлтый'

    class Transmission(enum.Enum):
        AUTOMATIC = 'Автоматическая'
        MANUAL = 'Ручная'
        ROBOT = 'Робот'

    def __init__(self, id_, short_name, seats=4, fuel_type='petrol'):
        self.id = id_
        self.short_name = short_name
        self.seats = seats
        self.fuel_type = fuel_type

    def __repr__(self):
        return self.short_name

    def localized_fuel_type(self, translations):
        fuel_type_key = 'car_model.fuel_type.{}'.format(self.fuel_type)
        return translations.gettext(fuel_type_key)

    def localized_name(self, translations):
        name_key = 'car_model.models.{}.name'.format(self.short_name)
        return translations.gettext(name_key)
