class City(object):

    def __init__(self, id_, code, short_name, location, polygon):
        self.id = id_
        self.code = code
        self.short_name = short_name
        self.location = location
        self.polygon = polygon

    def __eq__(self, other):
        return self.code == other.code

    def __hash__(self):
        return hash(self.code)

    def __ne__(self, other):
        return not(self == other)  # pylint: disable=superfluous-parens

    def __repr__(self):
        return '<City {} ({})>'.format(self.code, self.short_name)

    @property
    def _localization_key_prefix(self):
        return 'city.{}'.format(self.short_name)

    def localized_name(self, translation):
        name_key = '{}.name'.format(self._localization_key_prefix)
        return translation.gettext(name_key)
