import logging

import cars.settings
from cars.core.util import import_class


LOGGER = logging.getLogger(__name__)


class SmsNotifier:

    def __init__(self, yasms_client, sendsms_route=None):
        self._yasms = yasms_client
        self._sendsms_route = sendsms_route

    @classmethod
    def from_settings(cls):
        settings = cars.settings.YASMS
        yasms_client_class = import_class(settings['client_class'])
        yasms_client = yasms_client_class(
            url=settings['url'],
            sender=settings['sender'],
        )
        return cls(
            yasms_client=yasms_client,
            sendsms_route=settings['sendsms']['route'],
        )

    def send(self, phone, text):
        LOGGER.info('sending sms to phone `{}` with text `{}`. Route: `{}`'.format(
            phone, text, self._sendsms_route))
        return self._yasms.sendsms(phone=phone, text=text, route=self._sendsms_route)
