from rest_framework.serializers import (
    CharField,
    IntegerField,
    ModelSerializer,
    SerializerMethodField,
)

from cars.carsharing.models import Car
from cars.django.serializers import BaseSerializer


class DeptransCarInfoViewArgumentsSerializer(BaseSerializer):

    id = IntegerField(required=True)


class DeptransCarSerializer(ModelSerializer):
    """
    A serializer with the format, requested by RNIS Deptrans.
    """

    brand = SerializerMethodField()
    model = SerializerMethodField()

    gov_registration_number = CharField(source='number')
    telematics_id = IntegerField(source='imei')

    class Meta:
        model = Car
        fields = [
            'gov_registration_number',
            'telematics_id',
            'brand',
            'model',
        ]

    def get_brand(self, obj):
        return obj.model.manufacturer

    def get_model(self, obj):
        return obj.model.name
