from rest_framework.exceptions import PermissionDenied

import cars.settings
from cars.django.views import CarsharingAPIView


class DeptransAPIView(CarsharingAPIView):

    # not covered with parking permits, therefore no need to report them
    banned_model_codes = [
        'bmw_520i',
        'bmw_520i_w',
        'mercedes_e200',
        'mercedes_e200_w',
        'petrol_tanker',
        'petrol_tanker_2',
        'petrol_tanker_3',
        'porsche_carrera',
        'porsche_macan',
    ]

    def initial(self, request, *args, **kwargs):
        """
        Rather clumsy auth check.

        After DRIVEBACK-232 we don't have possibility to issue OAuth tokens for partners on demand,
        but still need to keep Deptrans auth working.

        So use plain comparison.
        """
        super().initial(request, *args, **kwargs)

        token = request.META.get('HTTP_AUTHORIZATION')
        if token is None:
            raise PermissionDenied

        if not token.endswith(cars.settings.DEPTRANS['token']):
            raise PermissionDenied
