import random

from factory.fuzzy import BaseFuzzyAttribute, FuzzyDateTime


class FuzzyPhoneNumber(BaseFuzzyAttribute):
    """
    Random phone number.

    Starts with +7, then 10 digits.
    The first 3 stand for the operator code.
    The rest stand for number
    """

    def fuzz(self):
        return '+7{}'.format(random.randint(10 ** 10, 10**11 - 1))


class FuzzyDateTimeString(BaseFuzzyAttribute):

    def __init__(self, date_format, date_fuzzy_class=FuzzyDateTime, args=(), kwargs={}):
        self.date_format = date_format
        self.date_fuzzy = date_fuzzy_class(*args, **kwargs)

    def fuzz(self):
        return self.date_fuzzy.fuzz().strftime(self.date_format)


class FuzzyBoolean(BaseFuzzyAttribute):

    def fuzz(self):
        return bool(random.randint(0, 1))
