class UwsgiLock(object):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        try:
            import uwsgi
            self._uwsgi = uwsgi
        except ImportError:
            # uwsgi is available only when run under uWSGI.
            self._uwsgi = None

    def __enter__(self):
        if self._uwsgi:
            self._uwsgi.lock()

    def __exit__(self, exc_type, exc_value, traceback):
        if self._uwsgi:
            self._uwsgi.unlock()
