from rest_framework.exceptions import NotFound
from rest_framework.pagination import PageNumberPagination
from rest_framework.response import Response


class Pagination(PageNumberPagination):
    page_size = 20
    page_size_query_param = 'per_page'
    max_page_size = 200

    def get_paginated_response(self, data):
        response_data = {
            'num_pages': self.page.paginator.num_pages,
            'page': self.page.number,
            'count': self.page.paginator.count,
            'results': data,
        }
        return Response(response_data)
