from rest_framework.parsers import BaseParser


class BinaryStreamParser(BaseParser):

    media_type = '*/*'

    def parse(self, stream, media_type, parser_context):  # pylint: disable=signature-differs
        return stream


class ImageBinaryStreamParser(BinaryStreamParser):
    media_type = 'image/*'


class VideoBinaryStreamParser(BinaryStreamParser):
    media_type = 'video/*'
