from rest_framework import renderers


class JPEGRenderer(renderers.BaseRenderer):
    media_type = 'image/jpeg'
    format = 'jpg'
    charset = None
    render_style = 'binary'

    def render(self, data, media_type=None, renderer_context=None):
        return data


class MP3Renderer(renderers.BaseRenderer):
    media_type = 'audio/mpeg'
    format = 'mp3'
    charset = None
    render_style = 'binary'

    def render(self, data, media_type=None, renderer_context=None):
        return data


class MP4Renderer(renderers.BaseRenderer):
    media_type = 'video/mp4'
    format = 'mp4'
    charset = None
    render_style = 'binary'

    def render(self, data, media_type=None, renderer_context=None):
        return data
