import os

import blackbox
from django_yauth.settings import *  # pylint: disable=wildcard-import,unused-wildcard-import

from cars.settings import (  # pylint: disable=no-name-in-module,unused-import
    API, BLACKBOX, DB, CAR_INDEX,
    DJANGO_AUTHENTICATION_BACKENDS, DJANGO_DEBUG, DJANGO_MIDDLEWARE,
    LOCALE_PATH, LOGGING, PUSH_CLIENT, YAUTH_TEST_USER, YAUTH_MECHANISMS, ZOOKEEPER,
)


AUTH_USER_MODEL = 'users.User'


# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '9@s#n@y7%pufq+06+t(r&ya44hfg+8y+i5*#l-ca%!qs%ho2a5'


DATABASES = {}
for db_name, db_config in DB.items():
    DATABASES[db_name] = {
        'ENGINE': 'django.db.backends.postgresql',
        'HOST': db_config['host'],
        'PORT': db_config['port'],
        'NAME': db_config['name'],
        'USER': db_config['user'],
        'PASSWORD': db_config['password'],
        'CONN_MAX_AGE': 60 * 15,  # 15 minutes.
        'DISABLE_SERVER_SIDE_CURSORS': True,
    }
    if 'pgaas' in DATABASES[db_name]['HOST']:
        DATABASES[db_name]['OPTIONS'] = {
            'sslmode': 'verify-full',
            'sslrootcert': os.environ.get(
                'CARSHARING_POSTGRES_SSLROOTCERT',
                '/opt/www/cars/.postgresql/allCAs.pem',
            ),
        }


DEBUG = DJANGO_DEBUG

ALLOWED_HOSTS = ['*']


AUTHENTICATION_BACKENDS = DJANGO_AUTHENTICATION_BACKENDS


# IDM
ROLES_HOOKS = 'cars.idm.hooks.CarsharingIdmHooks'


INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.messages',
    'django.contrib.postgres',
    'django.contrib.sessions',
    'django.contrib.staticfiles',

    'django_db_constraints',
    'phonenumber_field',
    'rest_framework',
    'rest_framework_swagger',

    'django_idm_api',
    'django_yauth',

    'cars.admin',
    'cars.aggregator',
    'cars.bans',
    'cars.billing',
    'cars.callcenter',
    'cars.callcenter_internal',
    'cars.carsharing',
    'cars.deptrans',
    'cars.drive',
    'cars.eka',
    'cars.infobip',
    'cars.fake',
    'cars.fines',
    'cars.head_unit',
    'cars.knowledge_base',
    'cars.orders',
    'cars.porsche',
    'cars.refuel',
    'cars.registration',
    'cars.registration_yang',
    'cars.request_aggregator',
    'cars.service_app',
    'cars.users',
    'cars.util',
    'cars.cars',
]

MIDDLEWARE = DJANGO_MIDDLEWARE

ROOT_URLCONF = 'cars.django.urls'


SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')


TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]


TEST_RUNNER = 'cars.django.test_runner.CarsharingTestRunner'


WSGI_APPLICATION = 'cars.django.wsgi.application'


# Internationalization
# https://docs.djangoproject.com/en/1.10/topics/i18n/

LANGUAGE_CODE = 'en'

LANGUAGES = [
    ('en', 'English'),
    ('hu', 'Hungarian'),
    ('ru', 'Russian'),
]

LOCALE_PATHS = [LOCALE_PATH]

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.10/howto/static-files/

STATIC_ROOT = os.path.join(BASE_DIR, 'static')
STATIC_URL = '/static/'


CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
    }
}


REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': [],
    'DEFAULT_PAGINATION_CLASS': None,
    'DEFAULT_PERMISSION_CLASSES': [],
    'EXCEPTION_HANDLER': 'cars.django.views.exception_handler',
    'TEST_REQUEST_DEFAULT_FORMAT': 'json',
}


CITY_HEADER = 'HTTP_CITY'
CLIENT_HEADER = 'HTTP_CLIENT'
LANG_HEADER = 'HTTP_LANG'


YAUTH_BLACKBOX_INSTANCE = blackbox.XmlBlackbox(url=BLACKBOX['url'])
YAUTH_BLACKBOX_PARAMS = {
    'aliases': 'all',
    'emails': 'getdefault',
    'getphones': 'all',
    'phone_attributes': '102',
}
YAUTH_CREATE_USER_ON_ACCESS = True

OLD_YAUTH_REAL_IP_HEADERS = YAUTH_REAL_IP_HEADERS
YAUTH_REAL_IP_HEADERS = (
    'HTTP_X_FORWARDED_FOR_Y',
) + OLD_YAUTH_REAL_IP_HEADERS

YAUTH_USE_NATIVE_USER = True
YAUTH_USE_SITES = False
YAUTH_USER_EXTRA_FIELDS = [
    ['default_email', 'email'],
    ['login', 'username'],
]
YAUTH_YAUSER_USERNAME_FIELD = 'uid'

if os.environ.get('IS_ADMIN_PORTAL') != '1':
    YAUTH_OAUTH_AUTHORIZATION_SCOPES = [
        'carsharing:all',
    ]

YAUTH_PASSPORT_URLS['desktop']['refresh'] = 'https://passport.yandex-team.ru/auth/update'
YAUTH_PASSPORT_URLS['mobile']['refresh'] = 'https://passport.yandex.ru/auth/update'

# YAUTH_MECHANISMS is provided in cars.settings
