from django.conf import settings
from django.conf.urls import include, url
from django.contrib import admin
from django.urls import path
from rest_framework_swagger.views import get_swagger_view

import cars.admin.urls
import cars.aggregator.views
import cars.aggregator.urls
import cars.billing.urls
import cars.calculator.urls
import cars.callcenter.urls
import cars.callcenter_internal.urls
import cars.deptrans.urls
import cars.django.views
import cars.drive.urls
import cars.eka.urls
import cars.infobip.urls
import cars.fake.urls
import cars.head_unit.urls
import cars.knowledge_base.urls
import cars.porsche.urls
import cars.refuel.urls
import cars.registration_yang.urls
import cars.registration.urls
import cars.request_aggregator.urls
import cars.service_app.urls
import cars.util.urls
import django_idm_api.urls


aggregator_urlpatterns = (
    [
        url(r'^api/carsharing/', include(cars.aggregator.urls)),
        url(r'^api/swagger/$', get_swagger_view(title='Aggregator API')),
    ],
    'aggregator',
)


urlpatterns = [
    url(
        r'^api/admin/v1/',
        include(cars.admin.urls, namespace='cars-admin'),
    ),
    url(
        r'^api/billing/v1/',
        include(cars.billing.urls, namespace='billing'),
    ),
    url(
        r'^api/calculator/v1/',
        include(cars.calculator.urls, namespace='calculator'),
    ),
    url(
        r'^api/callcenter/v1/',
        include(cars.callcenter.urls, namespace='callcenter'),
    ),
    url(
        r'^api/callcenter-internal/v1/',
        include(cars.callcenter_internal.urls, namespace='callcenter-internal'),
    ),
    url(
        r'^api/deptrans/v1/',
        include(cars.deptrans.urls, namespace='deptrans'),
    ),
    url(
        r'^api/drive/v1/',
        include(cars.drive.urls, namespace='drive'),
    ),
    # url(
    #     r'^api/idm/v1/',
    #     include(django_idm_api.urls),
    # ),
    url(
        r'^api/eka/v1/',
        include(cars.eka.urls, namespace='eka'),
    ),
    url(
        r'^api/head-unit/v1/',
        include(cars.head_unit.urls, namespace='head-unit'),
    ),
    url(
        r'^api/inapp/v1/',
        include(cars.fake.urls, namespace='fake'),
    ),
    url(
        r'^api/infobip/v1/',
        include(cars.infobip.urls, namespace='infobip'),
    ),
    url(
        r'^api/knowledge_base/v1/',
        include(cars.knowledge_base.urls, namespace='knowledge_base'),
    ),
    url(
        r'^api/ping/?',
        cars.django.views.PingView.as_view(),
        name='ping',
    ),
    url(
        r'^api/porsche/v1/',
        include(cars.porsche.urls, namespace='porsche'),
    ),
    url(
        r'^api/refuel/v1/',
        include(cars.refuel.urls, namespace='refuel'),
    ),
    url(
        r'^api/registration/v1/',
        include(cars.registration.urls, namespace='registration'),
    ),
    url(
        r'^api/registration_yang/v1/',
        include(cars.registration_yang.urls, namespace='registration_yang'),
    ),
    url(
        r'^api/request_aggregator/v1/',
        include(cars.request_aggregator.urls, namespace='request_aggregator'),
    ),
    url(
        r'^api/service_app/v1/',
        include(cars.service_app.urls, namespace='service_app'),
    ),
    url(
        r'^api/util/v1/',
        include(cars.util.urls, namespace='util'),
    ),
    path(
        r'django-admin/',
        admin.site.urls,
    ),
    url(
        r'^{}/'.format(settings.API['location_prefix']),
        include(aggregator_urlpatterns, namespace='aggregator'),
    ),
]
