import functools

from requests import HTTPError


class EvacuationException(Exception):
    def __init__(self, *args, **kwargs):
        super().__init__(*args)
        self._data = kwargs

    @property
    def error_origin(self):
        return self._data.get('error_origin', None)

    @property
    def error_code(self):
        error_code = self.data.get('error_data', {}).get('error_details', {}).get('http_code', 0)
        return error_code

    @property
    def error_code_name(self):
        error_code_name = self.data.get('error_data', {}).get('error_details', {}).get('special_info', {}).get('error_code', '')
        return error_code_name

    @property
    def data(self):
        return self._data


def handle_evacuation_error(error_origin):
    def wrapped(f):
        @functools.wraps(f)
        def wrapper(*args, **kwargs):
            try:
                return f(*args, **kwargs)

            except HTTPError as exc:
                error_response = exc.response.json()
                raise EvacuationException(
                    error_origin=error_origin,
                    error_data=error_response,
                ) from exc

        return wrapper

    return wrapped
