import cars.settings
from cars.core.push_client import CarsharingPushClientLogger
from cars.django.lock import UwsgiLock


class DrivePushClientLogger(CarsharingPushClientLogger):

    def __init__(self, filename):
        super().__init__(filename=filename, lock=UwsgiLock())

    def log(self, type_, data):
        type_ = 'drive.{}'.format(type_)
        super().log(type_=type_, data=data)


PUSH_CLIENT = DrivePushClientLogger(filename=cars.settings.DRIVE['push_client']['filename'])
