import logging


LOGGER = logging.getLogger(__name__)


class UserSetup(object):

    def __init__(self, email_suggested, email_verified, phone_suggested, phone_verified):
        self.email_suggested = email_suggested
        self.email_verified = email_verified
        self.phone_suggested = phone_suggested
        self.phone_verified = phone_verified

    @classmethod
    def from_request(cls, request):
        email_suggested, email_verified = cls.email_from_request(request)
        phone_suggested, phone_verified = cls.phone_from_request(request)
        return cls(
            email_suggested=email_suggested,
            email_verified=email_verified,
            phone_suggested=phone_suggested,
            phone_verified=phone_verified,
        )

    @classmethod
    def email_from_request(cls, request):
        if request.user.email is not None and request.user.phone is not None:
            # Hack to avoid asking for email on each login.
            email, verified = request.user.email, True
        else:
            email, verified = request.yauser.default_email or request.user.email, False
        return email, verified

    @classmethod
    def phone_from_request(cls, request):
        if request.user.phone:
            phone, verified = request.user.phone.as_e164, request.user.is_phone_verified
        else:
            try:
                raw_phones = request.yauser.blackbox_result.get('phones')
                if raw_phones:
                    phone = raw_phones[0]['attributes']['102']
                else:
                    phone = None
            except Exception:
                LOGGER.exception('failed to get user phone from blackbox response')
                phone = None
            verified = False
        return phone, verified
