import logging

from cars.core.daemons import CarsharingDaemon
from cars.core.util import handle_error

from ..core.incident.evacuation import (
    EvacuationTicketMonitoringHelper,
    EvacuationSTSTagMonitoringHelper,
    EvacuationTagEvolutionMonitoringHelper
)

LOGGER = logging.getLogger(__name__)


class EvacuationTagMonitoringDaemon(CarsharingDaemon):
    tick_interval = '*/2 * * * *'  # every 2 minutes

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._state_monitor_helper = EvacuationTicketMonitoringHelper.from_settings()
        self._tag_monitor_helper = EvacuationSTSTagMonitoringHelper.from_settings()
        self._tag_evolution_monitor_helper = EvacuationTagEvolutionMonitoringHelper.from_settings()

    def get_distributed_lock_relative_path(self):
        return '{}/locks/{}.lock'.format(self.get_solomon_service(), self.get_daemon_name())

    def get_solomon_sensor_prefix(self):
        return '{}.{}'.format(self.get_solomon_service(), self.get_daemon_name())

    def get_solomon_service(self):
        return 'drive'

    def get_daemon_name(self):
        return 'evacuation_tag_monitor'

    def _do_tick(self):
        with handle_error(re_raise=False):
            self._state_monitor_helper.process()

        with handle_error(re_raise=False):
            self._tag_monitor_helper.process()

        with handle_error(re_raise=False):
            self._tag_evolution_monitor_helper.process_tags_to_evolve()
