import uuid

from rest_framework.serializers import ValidationError

from cars.django.serializers import BaseSerializer


class DriveViewArgumentsSerializer(BaseSerializer):

    def to_internal_value(self, data):
        value = super().to_internal_value(data=data)

        request = self.context['request']
        value['uuid'] = request.META.get('HTTP_UUID')
        value['device_id'] = request.META.get('HTTP_DEVICEID')
        value['app_version'] = request.META.get('HTTP_APPVERSION')
        value['app_build'] = request.META.get('HTTP_APPBUILD')

        return value

    def validate(self, data):
        validated_data = super().validate(data)

        for uuid_field in ['uuid', 'device_id']:
            if validated_data[uuid_field] is not None:
                uuid_value = validated_data[uuid_field]
                try:
                    validated_data[uuid_field] = uuid.UUID(uuid_value)
                except ValueError:
                    raise ValidationError('Invalid UUID string: {}'.format(uuid_value))

        return validated_data
