from rest_framework.serializers import CharField, ModelSerializer

from cars.django.serializers import BaseSerializer
from cars.users.models.user_credit_card import UserCreditCard


class UserCreditCardViewArgumentsSerializer(BaseSerializer):
    paymethod_id = CharField()


class UserCreditCardSerializer(ModelSerializer):

    class Meta:
        model = UserCreditCard
        fields = '__all__'

    def to_representation(self, obj):
        return {
            'pan': {
                'prefix': obj.pan_prefix,
                'suffix': obj.pan_suffix,
            },
            'paymethod_id': obj.paymethod_id,
        }
