from rest_framework.serializers import CharField, ChoiceField, ValidationError

from cars.core.constants import AppPlatform
from .base import DriveViewArgumentsSerializer


class UserSessionViewArgumentsSerializer(DriveViewArgumentsSerializer):

    platform = ChoiceField([x.value for x in AppPlatform])
    push_token = CharField(required=False, default=None)

    def validate(self, data):
        validated_data = super().validate(data)

        for field in ['uuid', 'device_id']:
            if validated_data[field] is None:
                raise ValidationError('{} not provided'.format(field))

        validated_data['platform'] = AppPlatform(validated_data['platform'])

        return validated_data

    def to_internal_value(self, data):
        if 'apn_token' in data:
            assert 'push_token' not in data
            data['push_token'] = data.pop('apn_token')
        return super().to_internal_value(data)
