from django.conf.urls import url

from . import views

from cars.django.views import GoneView


app_name = 'drive'
urlpatterns = [
    url(r'^billing/repay-debt/$', views.RepayDebtView.as_view(), name='billing-repay-debt'),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/blink/$',
        views.BlinkCarCommandView.as_view(),
        name='car-command-blink',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/warmup/$',
        views.WarmupCommandView.as_view(),
        name='car-command-warmup',
    ),
    url(r'^debug/push/$', views.PushDebugView.as_view(), name='debug-push'),
    url(
        r'^intro/$',
        GoneView.as_view(),  # views.IntroView.as_view(),
        name='intro'
    ),
    url(r'^introscreens/$', views.IntroScreensView.as_view(), name='introscreens'),
    url(
        r'^orders/$',
        GoneView.as_view(),  # views.OrderListView.as_view(),
        name='order-list'
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/$',
        views.OrderDetailsView.as_view(),
        name='order-details',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/items/$',
        views.OrderItemListView.as_view(),
        name='order-item-list',
    ),
    url(
        r'^plus/landing-text/$',
        views.UserPlusPromoTextView.as_view(),
        name='user-plus-promo-text',
    ),
    url(
        r'^plus/landing-viewed/$',
        views.UserPlusPromoConfirmationView.as_view(),
        name='user-plus-promo-confirmation',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/items/(?P<order_item_id>[\w-]+)/$',
        views.OrderItemDetailsView.as_view(),
        name='order-item-details',
    ),
    url(
        r'^parking-area/$',
        GoneView.as_view(),  # views.ParkingAreaView.as_view(),
        name='parking-area',
    ),
    url(
        r'^user/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/thumbnail/$',
        views.UserDocumentPhotoThumbnailView.as_view(),
        name='user-document-photo-thumbnail',
    ),
    url(
        r'^user/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/bv/$',
        views.UserDocumentBackgroundVideoView.as_view(),
        name='user-document-photo-background-video',
    ),
    url(r'^user/consents/$', views.UserConsentsView.as_view(), name='user-consents'),
    url(
        r'^user/credit-card/$',
        GoneView.as_view(),  # views.UserCreditCardView.as_view(),
        name='user-credit-card'
    ),
    url(
        r'^user/email/$',
        GoneView.as_view(),  # views.UserEmailView.as_view(),
        name='user-email'
    ),
    url(r'^user/fines/$', views.UserFinesView.as_view(), name='user-fines'),
    url(
        r'^user/phones/commit/$',
        GoneView.as_view(),  # views.CommitUserPhonesView.as_view(),
        name='user-phones-commit'
    ),
    url(
        r'^user/phones/submit/$',
        GoneView.as_view(),  # views.SubmitUserPhonesView.as_view(),
        name='user-phones-submit'
    ),
    url(
        r'^user/session/$',
        GoneView.as_view(),  # views.UserSessionView.as_view()
        name='user-session'
    ),
    url(
        r'^send_promo_karaoke_email/$',
        views.KaraokePromoWebHookAPIView.as_view(),
        name='karaoke-promo'
    ),
]
