from rest_framework.response import Response

from cars.django.util import ReqAnsLogger
from cars.orders.core.order_debt_manager import OrderDebtManager
from cars.users.models.user import User
from ..core.push_client import PUSH_CLIENT
from ..serializers.user import UserSerializer
from .base import DriveAPIView


class RepayDebtView(DriveAPIView):

    reqans_logger_policy = ReqAnsLogger.Policy.FULL

    def do_post(self, request):
        user = (
            User.objects
            .select_related(
                'bonus_account',
                'credit_card',
            )
            .get(id=request.user.id)
        )

        debt_manager = OrderDebtManager.from_settings(push_client=PUSH_CLIENT)

        error = None
        try:
            debt_manager.repay_debt(user=user, timeout=25)
        except debt_manager.InsufficientFundsError:
            error = 'insufficient_funds'
        except debt_manager.Error:
            error = 'failure'

        data = {
            'user': UserSerializer(user).data,
        }
        if error is None:
            data['status'] = 'success'
        else:
            data['status'] = 'errors'
            data['errors'] = [error]

        return Response(data)
